//%attributes = {"publishedSql":true}
// Method: _blob_ TBL_XML_TO_ARR
// 2005.10.25-10:40:34 / ME
// © Copyright 2005 Manage Applications
// Purpose: 
// Parses xml data from a blob into a text array
// The xml data needs to be well-formatted, all opening
// tags need to be closed
// TODO 2005-10-26: check the format of xml
// ------------------------------------------------------------

C_POINTER:C301($_blob_pXmlData; $1; $_blob_pXmlArr; $2)

$_blob_pXmlData:=$1  // blob containing the xml data
$_blob_pXmlArr:=$2  // text array where the xml data is parsed

Case of 
	: (Type:C295($_blob_pXmlData->)#Is BLOB:K8:12)
		_err MESSAGE_PARAMETER("$1 not BLOB pointer"; Current method name:C684; kTrue)
	: (Type:C295($_blob_pXmlArr->)#Text array:K8:16)
		_err MESSAGE_PARAMETER("$2 not Text array pointer"; Current method name:C684; kTrue)
	Else 
		C_TEXT:C284($_blob_tChar; $_blob_tParsedText)
		C_LONGINT:C283($_blob_lSize; $_blob_lArrSize; $_blob_lIndex; $_blob_lByte; $_blob_lCounter; $_blob_lStartTag; $_blob_lEndTag)
		$_blob_lSize:=BLOB size:C605($_blob_pXmlData->)-1  // for loop count
		
		$_blob_lCounter:=0
		$_blob_lStartTag:=kFalse  // flag telling we are currently parsing a start tag
		$_blob_lEndTag:=kFalse  // flag telling we are currently parsing an end tag
		
		// TODO: optimizing? perhaps increase the array size in larger chunks?
		
		// read all chars from the blob and parse
		For ($_blob_lIndex; 0; $_blob_lSize)
			$_blob_lByte:=$_blob_pXmlData->{$_blob_lIndex}
			$_blob_tChar:=Char:C90($_blob_lByte)
			Case of 
					// start parsing a tag name          
				: ($_blob_tChar="<")
					$_blob_tParsedText:=_str TabCrLfReplace($_blob_tParsedText; "")  // remove formatting
					If ($_blob_tParsedText#"")  // it is tag data, closing a tag
						$_blob_lArrSize:=Size of array:C274($_blob_pXmlArr->)
						INSERT IN ARRAY:C227($_blob_pXmlArr->; $_blob_lArrsize+1)
						$_blob_pXmlArr->{$_blob_lArrsize}:=$_blob_tParsedText
						$_blob_tParsedText:=""
					End if 
					$_blob_lStartTag:=kTrue
					
					// finish parsing a tag name
				: ($_blob_tChar=">")
					$_blob_lArrSize:=Size of array:C274($_blob_pXmlArr->)
					INSERT IN ARRAY:C227($_blob_pXmlArr->; $_blob_lArrsize+1)
					// mark the start and end tags in the text array
					If ($_blob_lStartTag=kTrue)
						$_blob_pXmlArr->{$_blob_lArrsize}:="< "+$_blob_tParsedText
					Else   // end tag
						$_blob_pXmlArr->{$_blob_lArrsize}:="</"+$_blob_tParsedText
					End if 
					// now tag names begin with < in the array, the name starts at position 3         
					$_blob_tParsedText:=""
					$_blob_lStartTag:=kFalse
					$_blob_lEndTag:=kFalse
					
					// start parsing an end tag name
				: (($_blob_tChar="/") & ($_blob_lStartTag=kTrue))
					$_blob_lStartTag:=kFalse
					$_blob_lEndTag:=kTrue
					
					// parse text
				Else 
					$_blob_tParsedText:=$_blob_tParsedText+$_blob_tChar
					$_blob_lCounter:=$_blob_lCounter+1  // count the text length
					If ($_blob_lCounter>=32000)  // do not exceed max text length, also take into account base64 decoding
						$_blob_lArrSize:=Size of array:C274($_blob_pXmlArr->)
						INSERT IN ARRAY:C227($_blob_pXmlArr->; $_blob_lArrsize+1)
						$_blob_pXmlArr->{$_blob_lArrsize}:=$_blob_tParsedText
						$_blob_tParsedText:=""
						$_blob_lCounter:=0
					End if 
			End case 
		End for 
End case 
